package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jun 03, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class AmountableProvider {
    @Autowired
    private ApplicationContext context;

    public BaseAmountable<IWeapon> createWeaponAmountable() {
          return (BaseAmountable<IWeapon>) context.getBean("weaponAmountable");
    }

    public AmountablePrice<IWare> createWareAmountable() {
          return (AmountablePrice<IWare>) context.getBean("wareAmountable");
    }
}
