package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import org.joda.time.DateTime;
import org.joda.time.Years;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Service concerning the date.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on May 15, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class DateService {

    @Autowired
    private Date date;

    /**
     * Check if two dates represent the same day
     * @param date1
     * @param date2
     * @return
     */
    public boolean isSameDay(DateTime date1, DateTime date2) {
        return date1.toDateMidnight().equals(date2.toDateMidnight());
    }
    /**
     * Check if the date is today.
     * @param date
     * @return
     */
    public boolean isToday(DateTime date) {
        return date.toDateMidnight().equals(this.date.getCurrentDate().toDateMidnight());
    }

    /**
     * Check if a date lies in the past.
     * @param date to be checked.
     * @return true if the date is before the current game date
     */
    public boolean isPast(DateTime date) {
        return date.isBefore(this.date.getCurrentDate());
    }

    /**
     * Calculate the age.
     * @param birthDate
     * @return
     */
    public int getAge(DateTime birthDate) {
        return Years.yearsBetween(birthDate, date.getCurrentDate()).getYears();
    }

}
