package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import lombok.Getter;

/**
 * Extension of a simple message that is diplayed on the noticeboard. More information
 * can be displayed in the form of a dialog defined through a {@link DialogTemplate}.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 08, 2016
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class DisplayTemplateMessage extends DisplayMessage {
    @Getter
    private DialogTemplate dialogTemplate;

    public DisplayTemplateMessage(String messageKey, DialogTemplate template, Object...messageArgs) {
        super(messageKey, messageArgs);
        this.dialogTemplate = template;
    }
}
