package ch.sahits.game.openpatrician.model;

/**
 * Interface for balance data of the a week. The week must not necessairily be completed
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface IBalanceSheet {
	/**
	 * Retrieve the rental income
	 * @return
	 */
	public int getRentalIncome();
	/**
	 * Retrieve the wage costs
	 * @return
	 */
	public int getWageCosts();
	/**
	 * Retrieve the property taxes
	 * @return
	 */
	public int getPropertyTaxes();
	/**
	 * Retrieve the balance for the office trading
	 * @return
	 */
	public int getOfficeTrading();
	/**
	 * Retrieve the wages for the stewards
	 * @return
	 */
	public int getStewardCost();
	/**
	 * Retrieve other unspecified costs like fines
	 * @return
	 */
	public int getOtherCosts();

	void updateStewardCosts(int costPerDay);

	void updateRentalIncome(int incomePerDay);

	void deductPropertyTaxes(int amount);

	void updateSalaries(int saleriesPerDay);

	void updateAutomatedTradingCosts(long costsPerDay);

	void updateOtherExpensesRegular(int costsPerDay);

	void updateOtherExpensesOneTime(int costs);
}
