package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.map.IMap;
import javafx.beans.property.ObjectProperty;

/**
 * Model of the game.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 9, 2011
 *
 */
public interface IGame {
	/**
	 * Retrieve the map
	 * @return
	 */
	IMap getMap();
	/**
	 * check if the objective of the game is reached. This method may not be called by the server part
	 * @return
	 */
	boolean isObjectivReached();
	/**
	 * Set a new game speed
	 * @param speed
	 */
	void setGameSpeed(EGameSpeed speed);
	/**
	 * Retrieve the current game speed
	 * @return
	 */
	EGameSpeed getGameSpeed();

	/**
	 * Property for the game speed.
	 * @return
     */
	ObjectProperty<EGameSpeed> gameSpeedProperty();
	/**
	 * Retrieve the difficultiy level of the game
	 * @return
	 */
	Difficulty getDifficulty();
	/**
	 * Retrieve the game time
	 * @return
	 */
	Date getTime();

	/**
	 * Switch to fast forward until the first interuption.
	 */
	void fastForward();

	/**
	 * Return to normal speed.
	 */
	void normalSpeed();
}
