package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.AmountableProvider;
import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.Hashtable;
/**
 * Implementation for the storage of weapons
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeaponStorage implements IWeaponStorage {
	@MapType(key = IWeapon.class, value = BaseAmountable.class)
	private Hashtable<IWeapon, BaseAmountable<IWeapon>> storage = new Hashtable<>();
	@Autowired
	@XStreamOmitField
	private AmountableProvider amountableProvider;
	
	@PostConstruct
	private void init() {
		for (IWeapon weapon : EWeapon.values()){
			BaseAmountable<IWeapon> amountable = amountableProvider.createWeaponAmountable();
			storage.put(weapon, amountable);
		}
	}

	@Override
	public int getWeapon(IWeapon weapon) {
		return storage.get(weapon).getAmount();
	}

	@Override
	public int update(IWeapon weapon, int amount) {
		BaseAmountable<IWeapon> amountable = storage.get(weapon);
		int available = amountable.getAmount();
		if (amount<0){
			if (-amount > available) {
				amount = -available;  // can only move the available amount
			}
			amountable.remove(-amount);
		} else {
			amountable.add(amount);
		}
		return amount;
	}

	
	public boolean hasWeapons(){
		for (BaseAmountable<IWeapon> amount : storage.values()) {
			if (amount.getAmount()>0) return true;
		}
		return false;
	}

}
