package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.util.HashMap;
import java.util.Map;

/**
 * This is the local storage for the production workshops.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on May 14, 2016
 */
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
@Prototype
public class ProductionStorage {
    @MapType(key = IWare.class, value = Double.class)
    private Map<IWare, Double> storage = new HashMap<>();

    /**
     * Retrieve the amount that is stored of a specific ware.
     * @param ware
     * @return
     */
    public double getStored(IWare ware) {
        if (storage.containsKey(ware)) {
            return storage.get(ware);
        } else {
            return 0;
        }
    }

    /**
     * Transfer wares to/from the storage. Negative <code>amount</code>
     * values mean withdrawing from the storage.
     * @param ware
     * @param amount
     * @return the amount that was actually transfered
     */
    public double transfer(IWare ware, double amount) {
        double stored = getStored(ware);
        if (amount > 0) {
            stored += amount;
            storage.put(ware, stored);
            return amount;
        } else {
            if (stored + amount > 0) {
                // enough to withdraw
                stored += amount;
                storage.put(ware, stored);
                return amount;
            } else {
                storage.remove(ware);
                return -stored;
            }
        }
    }
}
