package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MapType;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 30, 2016
 */
@LazySingleton
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Shipyards implements Iterable<Entry<ICity, IShipyard>> {
    @MapType(key = ICity.class, value = IShipyard.class)
    private Map<ICity, IShipyard> shipyards = new HashMap<>();

    /**
     * Add a shipyard in the city.
     * @param shipyard
     * @param city
     */
    public void add(IShipyard shipyard, ICity city) {
        shipyards.put(city, shipyard);
    }

    /**
     * Retrieve the shipyard of the city. This method should not be called
     * when there is no shipyard at all.
     * @param city
     * @return
     */
    public IShipyard getShipyard(ICity city) {
        return shipyards.get(city);
    }

    @Override
    public Iterator<Entry<ICity, IShipyard>> iterator() {
        return shipyards.entrySet().iterator();
    }
}
