package ch.sahits.game.openpatrician.model.city.cityhall;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;

/**
 * Treasury of the city. The transient values hold the values of the current month.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ITreasury {
    /**
     * Retrieve the current height of the taxes.
     * @return
     */
    double getCurrentHeadTaxValue();

    /**
     * Retrieve the current property tax.
     * @return
     */
    double getCurrentPropertyTax();

    /**
     * Amount of the property and head taxes up to date this year.
     * @return
     */
    long getPaidTaxes();

    /**
     * Amount of the paid special taxes.
     * @return
     */
    long getPaidSpecialTaxes();

    /**
     * Monthly costs of the city guard.
     * @return
     */
    int getCityGuardCosts();

    /**
     * Costs for the building of city walls and towers up to date.
     * This value is only positive if there is a building being built.
     * @return
     */
    int getBuildingCosts();

    /**
     * Costs for paying the outrigger.
     * @return
     */
    int getOutriggerCosts();

    /**
     * Paid ransom to prevent/abort siege.
     * @return
     */
    int getSiegeCosts();

    /**
     * Costs and fees that the city has to have payed up to this date in the current year.
     * Included here are also stolen amounts.
     * @return
     */
    int getOtherCosts();

    /**
     * All other income like donations.
     * @return
     */
    int getOtherIncome();

    /**
     * All the donated amount.
     * @return
     */
    int getDonations();

    /**
     * Retrieve the whole amount in the treasury.
     * @return
     */
    long getCash();

    /**
     * Double property for the current head tax value.
     * @return current head tax value
     */
    DoubleProperty currentHeadTaxValueProperty();

    DoubleProperty currentPropertyTaxProperty();

    LongProperty paidTaxesProperty();

    LongProperty paidSpecialTaxesProperty();

    IntegerProperty cityGuardCostsProperty();

    IntegerProperty buildingCostsProperty();

    IntegerProperty outriggerCostsProperty();

    IntegerProperty siegeCostsProperty();

    IntegerProperty otherCostsProperty();

    IntegerProperty otherIncomeProperty();

    IntegerProperty donationsProperty();

    LongProperty cashProperty();
}
