package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.util.CancelableRunnable;
import org.joda.time.DateTime;

import java.util.List;
import java.util.Optional;

/**
 * Base model for the next auction hold in the guild.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
public interface IAuction {
    /**
     * Retrieve the date of the auction.
     * @return
     */
    DateTime getAuctionDate();

    /**
     * Set the auction date.
     * @param newDate
     */
    void setAuctionDate(DateTime newDate);

    /**
     * Retrieve the first bid amount.
     * @return
     */
    int getStartingBid();

    /**
     * Get the owner that is auctioning.
     * @return
     */
    Optional<IPlayer> getOwner();

    /**
     * Retrieve the current bid level.
     * @return
     */
    EBidLevel getBidLevel();

    /**
     * Set the new bid level.
     * @param level
     */
    void setBidLevel(EBidLevel level);

    /**
     * Retrieve the currently bidding player.
      * @return
     */
    IPlayer getBiddingPlayer();

    /**
     * Set the currently bidding player.
     * @param player
     */
    void setBiddingPlayer(IPlayer player);

    /**
     * Retrieve the current bid of the bidding player.
     * @return
     */
    int getCurrentBid();

    /**
     * Set the current bid.
     * @param bid
     */
    void setCurrentBid(int bid);

    /**
     * Retrieve the list of AI players that can bid.
     * @return
     */
    List<IAIPlayer> getBiddingPlayers();

    /**
     * Define the list of AI player that can bid.
     * @param players
     */
    void setBiddingPlayers(List<IAIPlayer> players);

    /**
     * Retrieve the current task.
      * @return
     */
    CancelableRunnable getCurrentTask();

    /**
     * Set the current task
     * @param task
     */
    void setCurrentTask(CancelableRunnable task);
}
