package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.guild.IBuildingAuction;
import lombok.Getter;
import org.joda.time.DateTime;

/**
 * Implement the auction for a building
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 13, 2016
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.MODEL, EClassCategory.PROTOTYPE_BEAN})
public class BuildingAuction extends AbstractAuction implements IBuildingAuction {
    @Getter
    private final IBuilding auctionedBuilding;

    /**
     * Create an auction for a building.
     * @param auctionDate
     * @param startingBid
     * @param owner
     * @param auctionedBuilding
     */
    public BuildingAuction(DateTime auctionDate, int startingBid, IPlayer owner, IBuilding auctionedBuilding) {
        super(auctionDate, startingBid, owner);
        this.auctionedBuilding = auctionedBuilding;
    }
}
