package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
@Prototype
@RequiredArgsConstructor
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Guild implements IGuild {
    @Getter
    private final ICity city;
    @Getter
    @ListType(IPlayer.class)
    private List<IPlayer> members = new ArrayList<>();
    @Getter
    @ListType(IAuction.class)
    private List<IAuction> auctions = new ArrayList<>();

    @Override
    public void join(IPlayer player) {
        members.add(player);
    }

    @Override
    public void resetAuction(IAuction auction) {
        auctions.remove(auction);
    }

}
