package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanCity;
import ch.sahits.game.openpatrician.model.city.guild.ITradeAgreement;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 04, 2016
 */
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
@Getter
@RequiredArgsConstructor
public class TradeAgreement implements ITradeAgreement {
    private final IMediterreanCity tradeLocation;
    private final DateTime validTill;
    private final IWare ware;
    private final AmountablePrice<IWare> wareAndAmount;

}
