package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.EChurchExtension;
import ch.sahits.game.openpatrician.model.city.IChurch;
import java.util.Optional;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 21, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ChurchState implements IChurch {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(ChurchState.class);

    @Getter
    private EChurchExtension extensionLevel = EChurchExtension.NONE;
    @Getter
    private int collectedDonationsForExtension = 0;

    @Override
    public void upgrade() {
        Optional<EChurchExtension> next = extensionLevel.getNextExtensionLevel();
        if (next.isPresent()) {
            extensionLevel = next.get();
            collectedDonationsForExtension = 0;
        } else {
            LOGGER.warn("Church cannot be extended as it is already extended to its max level.");
        }
    }

    public void makeDonation(int amount) {
        collectedDonationsForExtension += amount;
    }
}
