package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import org.joda.time.DateTime;

/**
 * Debt of a citizen to another citizen.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface IDebt {
    /**
     * Retrieve the citizen that is in debt.
     * @return
     */
    ICitizen getDebitor();

    /**
     * Retrieve the citizen that owns the debt.
     * @return
     */
    ICreditor getCreditor();

    /**
     * Retrieve the date when the debt has to be payed back.
     * @return
     */
    DateTime getDueDate();

    /**
     * Retrieve the duration in full days since taking the loan.
      * @return
     */
    long getLoanedDuration(DateTime now);

    /**
     * Retrieve the total duration of the loan in days.
     * @return
     */
    long getTotalDuration();

    /**
     * Interest of the debt over the whole duration.
     * @return
     */
    double getInterest();

    /**
     * Amount of money indebted without interest.
     * @return
     */
    int getAmount();
}
