package ch.sahits.game.openpatrician.model.map.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.annotation.SetType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.ITradeRouteStop;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;
import lombok.Setter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * Implementation of the {@link ITradeRouteStop}.
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class TradeRouteStop implements ITradeRouteStop {
    @Getter
    @Setter
    private ICity tradeStop;
    @Getter
    @SetType(IWare.class)
    private Set<IWare> waresToBuy = new HashSet<>();

    /**
     * Replace the wares to buy with the provided wares from the Collection.
     * @param waresToBuy
     */
    public void setWaresToBuy(Collection waresToBuy) {
        this.waresToBuy.clear();
        this.waresToBuy.addAll(waresToBuy);
    }
}
