package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.Getter;
import lombok.Setter;

import javax.annotation.PostConstruct;

/**
 * Implementation of a contract brooker. Every city can have a contract brooker and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class ContractBrookerState extends BaseTradePerson implements
IContractBroker {
    @Getter
    @Setter
	private String name;
    @Getter
    private final AmountablePrice<IWare> amountAndPrice;
    @Getter
    private final IWare ware;
    @Getter
    private int deliveredAmount = 0;
	/*
	 * TODO use brooker names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public ContractBrookerState(AmountablePrice<IWare> amountAndPrice, IWare ware) {
        super();
        this.amountAndPrice = amountAndPrice;
        this.ware = ware;
    }

    /**
	 * Generate a name of the broker.
	 */
    @PostConstruct
	private void update() {
		name = firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName();
	}


    @Override
    public void deliver(int amount) {

    }
}
