package ch.sahits.game.openpatrician.model.personal;

import lombok.Getter;

/**
 * Social rank of a player
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
@Getter
public enum ESocialRank {
	CHANDLER(0,0, 0, 6),
	BARGAINER(100000,3, 0, 5),
	MERCHANT(200000,3.4, 1, 4),
	TRADESMAN(300000,4, 2, 3),
	COUNCILMAN(500000,4.5, 3, 2),
	PATRICIAN(900000,4.7, 3, 0),
	MAYOR(0,5, 4, 0),
	ALDERMAN(0,5.3, 5, 0);

	private final int companyValue;
	private final double socialRank;
	private final int careerLowerOffset;
	private final int careerUpperOffset;

	ESocialRank(int companyValue, double socialRank, int careerLowerOffset, int careerUpperOffset) {
		this.companyValue = companyValue;
		this.socialRank = socialRank;
		this.careerLowerOffset = careerLowerOffset;
		this.careerUpperOffset = careerUpperOffset;
	}

	public ESocialRank getNextRank(){
		switch (this) {
			case CHANDLER:
				return BARGAINER;
			case BARGAINER:
				return MERCHANT;
			case MERCHANT:
				return TRADESMAN;
			case TRADESMAN:
				return COUNCILMAN;
			case COUNCILMAN:
				return PATRICIAN;
			case PATRICIAN:
				return MAYOR;
			case MAYOR:
				return ALDERMAN;
			case ALDERMAN:
				return ALDERMAN;
			default:
				return null;
		}
	}

}
