package ch.sahits.game.openpatrician.model.personal;

/**
 * Interface defining the personal data of the spouse
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public interface ISpouseData extends IPersonalData {
	/**
	 * Retrieve an portrait resource name
	 * @return
	 */
	String getPortraitResourceName();
	/**
	 * Retrieve her popularity in her home town
	 * @return
	 */
	int getPopularityInHerHomeTown();
	/**
	 * Retrieve her popularity in your home town
	 * @return
	 */
	int getPopularityInYourHomeTown();
	/**
	 * Retrieve the number of connections to councilmen in her hometown.
	 * @return
	 */
	int getConnectionsInHerHomeTown();
	/**
	 * Retrieve the number of connections to councilmen in your home town
	 * @return
	 */
	int getConnectionsInYourHomeTown();

}
