package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;

/**
 * A construction selection strategy decides if a new ship should be ordered,
 * where it should be built and what type it should be.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 30, 2016
 */
public interface IAIConstructionSelectionStrategy {
    /**
     * Check if a new ship should be ordered.
     * @param player for which the check should be done.
     * @return true if a new ship should be ordered.
     */
    boolean shouldOrderNewConstruction(IAIPlayer player);

    /**
     * Select the ship type to be built.
     * @param player
     * @return
     */
    EShipType shouldBuildShipType(IAIPlayer player);

    /**
     * Select the build location of the new ship.
     * @param player
     * @return
     */
    ICity getBuildLocation(IAIPlayer player);

    /**
     * Initialize the ship construction by collecting the wares. This boils down to selecting the correct implementation
     * of CollectConstructionWareStrategy. Once the ware is collected and delivered to the built location the order must be issued.
     * This happens in the AIPlayerEngine
     * @param player for whom to build the ship
     * @param buildLocation location where to build the ship
     * @param shipType type of the ship to be built.
     */
    void initShipConstruction(IAIPlayer player, ICity buildLocation, EShipType shipType);
}
