package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

/**
 * This interface defines the API for a trading strategy for the AI.
 */
public interface IAITradeStrategy {
    /**
     * Initialize the trade cycle. Based on the strategy the cycle may be closed,
     * meaning at some point this method can be called again or it may be open
     * with destination defining the next one.
     * @param player
     * @param vessel
     */
    void initialzeTradeCycle(IAIPlayer player, INavigableVessel vessel);

    /**
     * Execute the trad steps defined for the vessel.
     * @param player
     * @param vessel
     */
    boolean executeTradeSteps(IAIPlayer player, INavigableVessel vessel);

    void handleShipArrivesInPort(IShipEntersPortEvent event);
}
