package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

import java.util.List;

/**
 * Defining the model of the knowledge for production and consumption in all cities.
 */
public interface IProductionConsumptionKnowledge {
    /**
     * Update the knowledge of the city. An update of the knowledge uses the exact value.
     * @param city for which the knowledge should be updated.
     */
    void updateKnowledge(ICity city);

    /**
     * Retrieve the knowledge for a city.
     * @param city
     * @return
     */
    ICityProductionConsumptionKnowledge getKnowlege(ICity city);

    /**
     * Find cities that produce the ware and order them based on production amount and
     * distance.
     * @param distanceToCity city to which the producing city's distance should be considered.
     * @param ware  that should be produced.
     * @param vessel for which the list is retrieved
     * @return ordered list with the best production option at the beginning
     *
     */
    List<ICity> findListWithProductionsMinimalDistance(ICity distanceToCity, IWare ware, INavigableVessel vessel);

    /**
     * Find cities that need the <code>ware</code> and order them based on the need and the distance.
     * @param distanceToCity city to which the consuming city's distance should be considered.
     * @param ware that should be consumed
     * @param vessel for which the list is retrieved
     * @return ordered list with the cities that need the ware the most.
     */
    List<ICity> findCitiesWithNeedMinimalDistance(ICity distanceToCity, IWare ware, INavigableVessel vessel);
}
