package ch.sahits.game.openpatrician.model.product;

/**
 * Interface for a tradable good that can have a price that is calculated.
 */
public interface ITradable {
	/**
	 * Retrieve the value that is maximal payed for one unit of this ware
	 * if no ware is available.
	 * @return
	 */
	int getMaxValueBuy();

	/**
	 * Retrieve the value of the minimal payed sum for on unit if an infinitly amount
	 * of the ware exists.
	 * @return
	 */
	int getMinValueBuy();

	/**
	 * Retrieve the value that has to be minimally payed sum for one unit if infinitly amount of
	 * wares exist.
	 * @return
	 */
	int getMinValueSell();

	/**
	 * Retrieve the value that is to be maximally payed for one unit of this ware if no ware is available.
	 * @return
	 */
	int getMaxValueSell();

	/**
	 * Retrieve the amount of units which is considered infinite when selling. This influences the sell price because
	 * if there are so much units of the ware available the selling price will be the minimum.
	 * @return amount of units.
	 */
	int getMarketSaturationForSelling();

	/**
	 * Retrieve the amount of units which is considered infinite when buying. This influences the buy price
	 * because if there are that many units available the buy price does not change anymore.
	 * @return amount of units.
     */
	int getMarketSaturationForBuying();

	/**
	 * As this interface is implemented by an enumeration add this method
	 * @return
	 */
	String name();

	/**
	 * Retrieve the bezier curve defining the buy prices.
	 * @return
	 */
	IBezierPriceCurve getBuyCurve();

	/**
	 * Retrieve the bezier curve defining the sell prices.
 	 * @return
	 */
	IBezierPriceCurve getSellCurve();
}
