package ch.sahits.game.openpatrician.server;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.plugin.IMapPluginLoader;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;

/**
 * Service profiding access to map details, packed in the game an also in the plugins.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 14, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class MapProviderService {
    /**
     * Retrieve the map data consisting of key value pairs, where the key is the text key with which the map
     * should be represented and the value the path to the map definition XML on the classpath.
     * @return
     */
    public Map<String, String> getMaps() {
        LinkedHashMap<String, String> maps = new LinkedHashMap<>();
        maps.put("ch.sahits.game.graphic.display.scene.NewGameScene.standard", "/standartHanseaticMap.xml");
        ServiceLoader<IMapPluginLoader> mapLoaders = ServiceLoader.load(IMapPluginLoader.class, ClassLoader.getSystemClassLoader());
        for (IMapPluginLoader mapLoader : mapLoaders) {
            maps.put(mapLoader.getMapTextKey(), mapLoader.getMapDefinition());
        }
        return maps;
    }
}
