/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.openpatrician.IInvalidatable;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.IModelTranslationService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class Date
implements IInvalidatable {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(Date.class);
    public static final int DEFAULT_INVALID_START_YEAR = 0;
    private int tickUpdate;
    @ObjectPropertyType(value=DateTime.class)
    private ObjectProperty<DateTime> cal = new SimpleObjectProperty((Object)this, "cal", null);
    private DateTime startDate;
    private Integer startYear = null;
    private static Object lock = new Object();
    @XStreamOmitField
    private StringBinding dayDateBinding = null;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private IModelTranslationService modelTranslationService;
    @Autowired
    @XStreamOmitField
    private DateService dateService;

    public Date(int year) {
        this();
        this.setStartYear(year);
    }

    public Date() {
        this.tickUpdate = 5;
    }

    public void resetStartYear(int startYear) {
        LOGGER.debug("Set the start year: {}", new Object[]{startYear});
        this.startYear = startYear;
        this.updateTime(new DateTime(startYear, 7, 13, 0, 0));
        this.startDate = this.getCurrentDate();
    }

    public void setStartYear(int startYear) {
        Preconditions.checkState((boolean)this.checkStartYear(startYear), (Object)"Date may only be initialized once");
        this.resetStartYear(startYear);
    }

    private boolean checkStartYear(int startYear) {
        if (this.startYear == null) {
            return true;
        }
        return this.startYear == 0;
    }

    @VisibleForTesting
    Date(DateTime cal) {
        this.updateTime(cal);
        this.startYear = cal.getYear();
        this.tickUpdate = 5;
    }

    public void updateTime(DateTime newTime) {
        if (this.cal.get() != null && !this.dateService.isToday(newTime) && this.dayDateBinding != null) {
            this.dayDateBinding.invalidate();
        }
        Preconditions.checkNotNull((Object)newTime);
        this.cal.set((Object)newTime);
    }

    public void setTickUpdate(int minutes) {
        this.tickUpdate = minutes;
        ClockTickIntervalChange event = new ClockTickIntervalChange();
        event.setInterval(this.tickUpdate);
        this.clientServerEventBus.post((Object)event);
    }

    public StringBinding dayDateBinding() {
        if (this.dayDateBinding == null) {
            this.dayDateBinding = new StringBinding(){

                protected String computeValue() {
                    return Date.this.modelTranslationService.toDisplayString((DateTime)Date.this.cal.get());
                }
            };
        }
        return this.dayDateBinding;
    }

    public DateTime getCurrentDate() {
        return (DateTime)this.cal.get();
    }

    public ObjectProperty<DateTime> getCurrentDateProperty() {
        return this.cal;
    }

    public void invalidate() {
        this.dayDateBinding.invalidate();
        this.dayDateBinding = null;
        this.dayDateBinding();
    }

    public int getTickUpdate() {
        return this.tickUpdate;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public Integer getStartYear() {
        return this.startYear;
    }
}

