/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.EDifficultyLevel;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public final class Difficulty {
    public static final Difficulty CHANDLER = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, 30000, 2, "chandler");
    public static final Difficulty MERCHANT = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 2, "merchant");
    public static final Difficulty TRADESMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 1, "tradesman");
    public static final Difficulty COUNSILMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1, "counsilman");
    public static final Difficulty PATRICIAN = new Difficulty(EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1, "patrician");
    private final EDifficultyLevel trade;
    private final EDifficultyLevel approval;
    private final EDifficultyLevel need;
    private final EDifficultyLevel navalBattle;
    private final EDifficultyLevel pirateActivity;
    private final EDifficultyLevel sovereignActivity;
    private final int startingCapital;
    private final int numberOfShips;
    private final String level;

    public static Difficulty fromIndex(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                return CHANDLER;
            }
            case 1: {
                return MERCHANT;
            }
            case 2: {
                return TRADESMAN;
            }
            case 3: {
                return COUNSILMAN;
            }
            case 4: {
                return PATRICIAN;
            }
        }
        throw new IndexOutOfBoundsException("No matching difficulty for index " + selectedIndex);
    }

    public Difficulty(EDifficultyLevel trade, EDifficultyLevel approval, EDifficultyLevel need, EDifficultyLevel navalBattle, EDifficultyLevel pirateActivity, EDifficultyLevel sovereignActivity, int startingCapital, int numberOfShips, String name) {
        this.trade = trade;
        this.approval = approval;
        this.need = need;
        this.navalBattle = navalBattle;
        this.pirateActivity = pirateActivity;
        this.sovereignActivity = sovereignActivity;
        this.startingCapital = startingCapital;
        this.numberOfShips = numberOfShips;
        this.level = name;
    }

    public EDifficultyLevel getTrade() {
        return this.trade;
    }

    public EDifficultyLevel getApproval() {
        return this.approval;
    }

    public EDifficultyLevel getNeed() {
        return this.need;
    }

    public EDifficultyLevel getNavalBattle() {
        return this.navalBattle;
    }

    public EDifficultyLevel getPirateActivity() {
        return this.pirateActivity;
    }

    public EDifficultyLevel getSovereignActivity() {
        return this.sovereignActivity;
    }

    public int getStartingCapital() {
        return this.startingCapital;
    }

    public int getNumberOfShips() {
        return this.numberOfShips;
    }

    public String getLevel() {
        return this.level;
    }
}

