/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.EElectionType;
import ch.sahits.game.openpatrician.model.city.cityhall.IElectionResult;
import java.util.HashMap;
import java.util.Map;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Election
implements IElectionResult {
    private final EElectionType type;
    @MapType(key=ICitizen.class, value=Integer.class)
    private Map<ICitizen, Integer> votes = new HashMap<ICitizen, Integer>();

    public Election(EElectionType type) {
        this.type = type;
    }

    @Override
    public void vote(ICitizen citizen) {
        if (this.votes.containsKey(citizen)) {
            this.votes.put(citizen, this.votes.get(citizen) + 1);
        } else {
            this.votes.put(citizen, 1);
        }
    }

    public EElectionType getType() {
        return this.type;
    }

    @Override
    public Map<ICitizen, Integer> getVotes() {
        return this.votes;
    }
}

