/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BalanceSheet
implements IBalanceSheet {
    private final ICity city;
    private final IPlayer player;
    @Autowired
    private Date gameDate;
    private int rentalIncome;
    private int[] rentalIncomeDays;
    private int wageCosts;
    private int[] wageCostsDays;
    private int propertyTaxes;
    private int officeTrading;
    private int[] officeTradingDays;
    private int stewardCost;
    private int[] stewardCostsDays;
    private int otherCosts;
    private int[] otherCostsDays;

    public BalanceSheet(ICity city, IPlayer player) {
        this.city = city;
        this.player = player;
        this.rentalIncome = 0;
        this.rentalIncomeDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.wageCosts = 0;
        this.wageCostsDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.propertyTaxes = 0;
        this.officeTrading = 0;
        this.officeTradingDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.stewardCost = 0;
        this.stewardCostsDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.otherCosts = 0;
        this.otherCostsDays = new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public BalanceSheet(BalanceSheet prevWeek) {
        this.city = prevWeek.city;
        this.player = prevWeek.player;
        this.rentalIncome = prevWeek.rentalIncomeDays[6] * 7;
        this.rentalIncomeDays = new int[]{prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6], prevWeek.rentalIncomeDays[6]};
        this.wageCosts = prevWeek.wageCostsDays[6] * 7;
        this.wageCostsDays = new int[]{prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6]};
        this.officeTradingDays = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.officeTradingDays = new int[]{prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6], prevWeek.officeTradingDays[6]};
        this.stewardCost = prevWeek.stewardCostsDays[6] * 7;
        this.stewardCostsDays = new int[]{prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6], prevWeek.stewardCostsDays[6]};
        this.otherCosts = prevWeek.otherCosts;
        this.otherCostsDays = new int[]{prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7, prevWeek.otherCosts / 7};
    }

    @Override
    public void updateStewardCosts(int costPerDay) {
        int weekIndex;
        for (int i = weekIndex = this.getWeekIndex(); i < this.stewardCostsDays.length; ++i) {
            this.stewardCostsDays[i] = costPerDay;
        }
        int sum = 0;
        for (int cost : this.stewardCostsDays) {
            sum += cost;
        }
        this.stewardCost = sum;
    }

    @Override
    public void updateRentalIncome(int incomePerDay) {
        int weekIndex;
        for (int i = weekIndex = this.getWeekIndex(); i < this.rentalIncomeDays.length; ++i) {
            this.rentalIncomeDays[i] = incomePerDay;
        }
        int sum = 0;
        for (int cost : this.rentalIncomeDays) {
            sum += cost;
        }
        this.rentalIncome = sum;
    }

    @Override
    public void deductPropertyTaxes(int amount) {
        this.propertyTaxes = amount;
    }

    @Override
    public void updateSalaries(int saleriesPerDay) {
        int weekIndex;
        for (int i = weekIndex = this.getWeekIndex(); i < this.wageCostsDays.length; ++i) {
            this.wageCostsDays[i] = saleriesPerDay;
        }
        int sum = 0;
        for (int cost : this.wageCostsDays) {
            sum += cost;
        }
        this.wageCosts = sum;
    }

    @Override
    public void updateAutomatedTradingCosts(long costs) {
        int weekIndex = this.getWeekIndex();
        this.officeTradingDays[weekIndex - 1] = (int)costs;
        this.officeTrading = (int)((long)this.officeTrading + costs);
    }

    @Override
    public void updateOtherExpensesRegular(int costsPerDay) {
        int weekIndex;
        for (int i = weekIndex = this.getWeekIndex(); i < this.otherCostsDays.length; ++i) {
            this.otherCostsDays[i] = costsPerDay;
        }
        int sum = 0;
        for (int cost : this.otherCostsDays) {
            sum += cost;
        }
        this.otherCosts = sum;
    }

    @Override
    public void updateOtherExpensesOneTime(int costs) {
        int weekIndex = this.getWeekIndex();
        this.otherCostsDays[weekIndex - 1] = costs;
        this.otherCosts += costs;
    }

    private int getWeekIndex() {
        return this.gameDate.getCurrentDate().getDayOfWeek();
    }

    @Override
    public int getRentalIncome() {
        return this.rentalIncome;
    }

    @Override
    public int getWageCosts() {
        return this.wageCosts;
    }

    @Override
    public int getPropertyTaxes() {
        return this.propertyTaxes;
    }

    @Override
    public int getOfficeTrading() {
        return this.officeTrading;
    }

    @Override
    public int getStewardCost() {
        return this.stewardCost;
    }

    @Override
    public int getOtherCosts() {
        return this.otherCosts;
    }
}

