/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.product.BezierPriceCurve;
import ch.sahits.game.openpatrician.model.product.EWareSize;
import ch.sahits.game.openpatrician.model.product.IBezierPriceCurve;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import com.google.common.base.Preconditions;
import java.util.Properties;
import javafx.geometry.Point2D;

public enum EWare implements IWare
{
    BEER("beer.properties"),
    IRONORE("ironore.properties"),
    IRON("iron.properties"),
    FUR("fur.properties"),
    FISH("fish.properties"),
    MEAT("meat.properties"),
    GRAIN("grain.properties"),
    SPICE("spice.properties"),
    HEMP("hemp.properties"),
    WOOD("wood.properties"),
    HONEY("honey.properties"),
    POTTERY("pottery.properties"),
    LEATHER("leather.properties"),
    PITCH("pitch.properties"),
    SALT("salt.properties"),
    FISH_OIL("fishoil.properties"),
    CLOTH("cloth.properties"),
    WINE("wine.properties"),
    WOOL("wool.properties"),
    BRICK("brick.properties");

    private final EWareSize size;
    private final int maxValueBuy;
    private final int minValueBuy;
    private final int maxValueSell;
    private final int minValueSell;
    private final int marketSaturationForSelling;
    private final int marketSaturationForBuying;
    private final String wareID;
    private final int maxBuyPriceModerate;
    private final int maxBuyPriceOffensive;
    private final int maxBuyPriceRabiat;
    private final double aiMaxBuyPercentage;
    private final int aiMaxBuyAbsolute;
    private final IBezierPriceCurve buyCurve;
    private final IBezierPriceCurve sellCurve;

    private EWare(String configFileName) {
        Properties props = PropertyLoader.loadProperties((String)configFileName);
        Preconditions.checkNotNull((Object)props.getProperty("type"), (Object)("The property file " + configFileName + " does not contain the type property"));
        Preconditions.checkNotNull((Object)props.getProperty("sizeUnit"), (Object)("The property file " + configFileName + " does not contain the sizeUnit property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxValueBuy"), (Object)("The property file " + configFileName + " does not contain the maxValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueBuy"), (Object)("The property file " + configFileName + " does not contain the minValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxValueSell"), (Object)("The property file " + configFileName + " does not contain the maxValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueSell"), (Object)("The property file " + configFileName + " does not contain the maxValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("localisationID"), (Object)("The property file " + configFileName + " does not contain the localisationID property"));
        Preconditions.checkNotNull((Object)props.getProperty("saturation"), (Object)("The property file " + configFileName + " does not contain the saturation property"));
        Preconditions.checkNotNull((Object)props.getProperty("saturationBuy"), (Object)("The property file " + configFileName + " does not contain the saturationBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxBuyPriceModerate"), (Object)("The property file " + configFileName + " does not contain the maxBuyPriceModerate property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxBuyPriceOffensive"), (Object)("The property file " + configFileName + " does not contain the maxBuyPriceOffensive property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxBuyPriceRabiat"), (Object)("The property file " + configFileName + " does not contain the maxBuyPriceRabiat property"));
        Preconditions.checkNotNull((Object)props.getProperty("ai.maxBuy.percentage"), (Object)("The property file " + configFileName + " does not contain the ai.maxBuy.percentage property"));
        Preconditions.checkNotNull((Object)props.getProperty("ai.maxBuy.absolute"), (Object)("The property file " + configFileName + " does not contain the ai.maxBuy.absolute property"));
        this.size = EWareSize.valueOf(props.getProperty("sizeUnit"));
        this.maxValueBuy = Integer.parseInt(props.getProperty("maxValueBuy"));
        this.minValueBuy = Integer.parseInt(props.getProperty("minValueBuy"));
        this.wareID = props.getProperty("localisationID");
        this.marketSaturationForSelling = Integer.parseInt(props.getProperty("saturation"));
        this.marketSaturationForBuying = Integer.parseInt(props.getProperty("saturationBuy"));
        this.minValueSell = Integer.parseInt(props.getProperty("minValueSell"));
        this.maxValueSell = Integer.parseInt(props.getProperty("maxValueSell"));
        this.maxBuyPriceModerate = Integer.parseInt(props.getProperty("maxBuyPriceModerate"));
        this.maxBuyPriceOffensive = Integer.parseInt(props.getProperty("maxBuyPriceOffensive"));
        this.maxBuyPriceRabiat = Integer.parseInt(props.getProperty("maxBuyPriceRabiat"));
        this.aiMaxBuyPercentage = Double.parseDouble(props.getProperty("ai.maxBuy.percentage"));
        this.aiMaxBuyAbsolute = Integer.parseInt(props.getProperty("ai.maxBuy.absolute"));
        Point2D buyStart = new Point2D(0.0, (double)this.maxValueBuy);
        Point2D buyEnd = new Point2D((double)this.marketSaturationForBuying, (double)this.minValueBuy);
        Point2D sellStart = new Point2D(0.0, (double)this.maxValueSell);
        Point2D sellEnd = new Point2D((double)this.marketSaturationForSelling, (double)this.minValueSell);
        int buyCp1X = Integer.parseInt(props.getProperty("buy.cp1.x"));
        int buyCp1Y = Integer.parseInt(props.getProperty("buy.cp1.y"));
        int buyCp2X = Integer.parseInt(props.getProperty("buy.cp2.x"));
        int buyCp2Y = Integer.parseInt(props.getProperty("buy.cp2.y"));
        int sellCp1X = Integer.parseInt(props.getProperty("sell.cp1.x"));
        int sellCp1Y = Integer.parseInt(props.getProperty("sell.cp1.y"));
        int sellCp2X = Integer.parseInt(props.getProperty("sell.cp2.x"));
        int sellCp2Y = Integer.parseInt(props.getProperty("sell.cp2.y"));
        Point2D buyCp1 = new Point2D((double)buyCp1X, (double)buyCp1Y);
        Point2D buyCp2 = new Point2D((double)buyCp2X, (double)buyCp2Y);
        Point2D sellCp1 = new Point2D((double)sellCp1X, (double)sellCp1Y);
        Point2D sellCp2 = new Point2D((double)sellCp2X, (double)sellCp2Y);
        this.buyCurve = new BezierPriceCurve(buyStart, buyCp1, buyCp2, buyEnd);
        this.sellCurve = new BezierPriceCurve(sellStart, sellCp1, sellCp2, sellEnd);
    }

    @Override
    public final boolean isBarrelSizedWare() {
        return this.size == EWareSize.BARREL;
    }

    @Override
    public final short getSizeAsBarrels() {
        return this.size.getRealMasurement();
    }

    @Override
    public int getMaxValueBuy() {
        return this.maxValueBuy;
    }

    @Override
    public int getMinValueBuy() {
        return this.minValueBuy;
    }

    @Override
    public int getMaxValueSell() {
        return this.maxValueSell;
    }

    @Override
    public int getMinValueSell() {
        return this.minValueSell;
    }

    @Override
    public int getMarketSaturationForSelling() {
        return this.marketSaturationForSelling;
    }

    @Override
    public int getMarketSaturationForBuying() {
        return this.marketSaturationForBuying;
    }

    public String getWareID() {
        return this.wareID;
    }

    @Override
    public int getMaxBuyPriceModerate() {
        return this.maxBuyPriceModerate;
    }

    @Override
    public int getMaxBuyPriceOffensive() {
        return this.maxBuyPriceOffensive;
    }

    @Override
    public int getMaxBuyPriceRabiat() {
        return this.maxBuyPriceRabiat;
    }

    @Override
    public double getAiMaxBuyPercentage() {
        return this.aiMaxBuyPercentage;
    }

    @Override
    public int getAiMaxBuyAbsolute() {
        return this.aiMaxBuyAbsolute;
    }

    @Override
    public IBezierPriceCurve getBuyCurve() {
        return this.buyCurve;
    }

    @Override
    public IBezierPriceCurve getSellCurve() {
        return this.sellCurve;
    }
}

