/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.product.BezierPriceCurve;
import ch.sahits.game.openpatrician.model.product.IBezierPriceCurve;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import com.google.common.base.Preconditions;
import java.util.Properties;
import javafx.geometry.Point2D;

public enum EWeapon implements IWeapon
{
    SWORD("sword.properties"),
    BOW("bow.properties"),
    CROSSBOW("crossbow.properties"),
    MUSKET("musket.properties"),
    BALLISTA_SMALL("ballista_small.properties"),
    TREBUCHET_SMALL("trebuchet_small.properties"),
    BALLISTA_BIG("ballista_big.properties"),
    TREBUCHET_BIG("trebuchet_big.properties"),
    BOMBARD("bombard.properties"),
    CANNON("cannon.properties"),
    HAND_WEAPON("hand_weapon.properties");

    private final int maxValueBuy;
    private final int minValueBuy;
    private final int maxValueSell;
    private final int minValueSell;
    private final int marketSaturationForSelling;
    private final int marketSaturationForBuying;
    private final IBezierPriceCurve buyCurve;
    private final IBezierPriceCurve sellCurve;

    private EWeapon(String configFileName) {
        Properties props = PropertyLoader.loadProperties((String)configFileName);
        Preconditions.checkNotNull((Object)props.getProperty("maxValueBuy"), (Object)("The property file " + configFileName + " does not contain the maxValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueBuy"), (Object)("The property file " + configFileName + " does not contain the minValueBuy property"));
        Preconditions.checkNotNull((Object)props.getProperty("maxValueSell"), (Object)("The property file " + configFileName + " does not contain the maxValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("minValueSell"), (Object)("The property file " + configFileName + " does not contain the minValueSell property"));
        Preconditions.checkNotNull((Object)props.getProperty("saturation"), (Object)("The property file " + configFileName + " does not contain the saturation property"));
        this.maxValueBuy = Integer.parseInt(props.getProperty("maxValueBuy"));
        this.minValueBuy = Integer.parseInt(props.getProperty("minValueBuy"));
        this.marketSaturationForSelling = Integer.parseInt(props.getProperty("saturation"));
        this.marketSaturationForBuying = Integer.parseInt(props.getProperty("saturation"));
        this.minValueSell = Integer.parseInt(props.getProperty("minValueSell"));
        this.maxValueSell = Integer.parseInt(props.getProperty("maxValueSell"));
        Point2D buyStart = new Point2D(0.0, (double)this.maxValueBuy);
        Point2D buyEnd = new Point2D((double)this.marketSaturationForBuying, (double)this.minValueBuy);
        Point2D sellStart = new Point2D(0.0, (double)this.maxValueSell);
        Point2D sellEnd = new Point2D((double)this.marketSaturationForSelling, (double)this.minValueSell);
        int buyCp1X = Integer.parseInt(props.getProperty("buy.cp1.x"));
        int buyCp1Y = Integer.parseInt(props.getProperty("buy.cp1.y"));
        int buyCp2X = Integer.parseInt(props.getProperty("buy.cp2.x"));
        int buyCp2Y = Integer.parseInt(props.getProperty("buy.cp2.y"));
        int sellCp1X = Integer.parseInt(props.getProperty("sell.cp1.x"));
        int sellCp1Y = Integer.parseInt(props.getProperty("sell.cp1.y"));
        int sellCp2X = Integer.parseInt(props.getProperty("sell.cp2.x"));
        int sellCp2Y = Integer.parseInt(props.getProperty("sell.cp2.y"));
        Point2D buyCp1 = new Point2D((double)buyCp1X, (double)buyCp1Y);
        Point2D buyCp2 = new Point2D((double)buyCp2X, (double)buyCp2Y);
        Point2D sellCp1 = new Point2D((double)sellCp1X, (double)sellCp1Y);
        Point2D sellCp2 = new Point2D((double)sellCp2X, (double)sellCp2Y);
        this.buyCurve = new BezierPriceCurve(buyStart, buyCp1, buyCp2, buyEnd);
        this.sellCurve = new BezierPriceCurve(sellStart, sellCp1, sellCp2, sellEnd);
    }

    @Override
    public int getMaxValueBuy() {
        return this.maxValueBuy;
    }

    @Override
    public int getMinValueBuy() {
        return this.minValueBuy;
    }

    @Override
    public int getMaxValueSell() {
        return this.maxValueSell;
    }

    @Override
    public int getMinValueSell() {
        return this.minValueSell;
    }

    @Override
    public int getMarketSaturationForSelling() {
        return this.marketSaturationForSelling;
    }

    @Override
    public int getMarketSaturationForBuying() {
        return this.marketSaturationForBuying;
    }

    @Override
    public IBezierPriceCurve getBuyCurve() {
        return this.buyCurve;
    }

    @Override
    public IBezierPriceCurve getSellCurve() {
        return this.sellCurve;
    }
}

