/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.dialog;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.beans.ConstructorProperties;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class ButtonTemplate {
    private final String labelKey;
    private final boolean largeButton;
    private final Runnable action;

    public static ButtonTemplateBuilder builder() {
        return new ButtonTemplateBuilder();
    }

    @ConstructorProperties(value={"labelKey", "largeButton", "action"})
    public ButtonTemplate(String labelKey, boolean largeButton, Runnable action) {
        this.labelKey = labelKey;
        this.largeButton = largeButton;
        this.action = action;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public boolean isLargeButton() {
        return this.largeButton;
    }

    public Runnable getAction() {
        return this.action;
    }

    public static class ButtonTemplateBuilder {
        private String labelKey;
        private boolean largeButton;
        private Runnable action;

        ButtonTemplateBuilder() {
        }

        public ButtonTemplateBuilder labelKey(String labelKey) {
            this.labelKey = labelKey;
            return this;
        }

        public ButtonTemplateBuilder largeButton(boolean largeButton) {
            this.largeButton = largeButton;
            return this;
        }

        public ButtonTemplateBuilder action(Runnable action) {
            this.action = action;
            return this;
        }

        public ButtonTemplate build() {
            return new ButtonTemplate(this.labelKey, this.largeButton, this.action);
        }

        public String toString() {
            return "ButtonTemplate.ButtonTemplateBuilder(labelKey=" + this.labelKey + ", largeButton=" + this.largeButton + ", action=" + this.action + ")";
        }
    }
}

