/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ProductionStorage;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.util.MapInitializedBean;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=MapInitializedBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class CityProductionStorage {
    @MapType(key=ICity.class, value=ProductionStorage.class)
    private Map<ICity, ProductionStorage> storage = new HashMap<ICity, ProductionStorage>();
    @Autowired
    private IMap map;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        for (ICity city : this.map.getCities()) {
            this.add(city);
        }
    }

    public void add(ICity city) {
        this.storage.put(city, (ProductionStorage)this.context.getBean(ProductionStorage.class));
    }

    public ProductionStorage getStorage(ICity city) {
        return this.storage.get(city);
    }
}

