/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class PopulationConsume {
    @MapType(key=EWare.class, value=Map.class)
    private Map<EWare, Map<EPopulationClass, Double>> needs = new HashMap<EWare, Map<EPopulationClass, Double>>();

    public PopulationConsume(String propFileName) {
        Properties props = PropertyLoader.loadProperties((String)propFileName);
        EWare[] wares = EWare.values();
        EPopulationClass[] classes = EPopulationClass.values();
        for (EWare ware : wares) {
            String wareName = ware.name();
            HashMap<EPopulationClass, Double> inner = new HashMap<EPopulationClass, Double>();
            for (EPopulationClass popClass : classes) {
                String key = wareName + "_" + popClass.name();
                double val = popClass == EPopulationClass.BEGGAR ? 0.0 : Double.parseDouble(props.getProperty(key));
                inner.put(popClass, val);
            }
            this.needs.put(ware, inner);
        }
    }

    public PopulationConsume() {
        this("populationConsume_default.properties");
    }

    public double getNeed(IWare ware, EPopulationClass popClass, int popSize) {
        double d = this.needs.get(ware).get((Object)popClass);
        return d *= (double)popSize / 1000.0;
    }

    public double getWeeklyConsumption(IWare ware, ICity city) {
        double amount = 0.0;
        for (EPopulationClass popClass : EPopulationClass.values()) {
            amount += this.getNeed(ware, popClass, city.getPopulation(popClass));
        }
        return amount;
    }

    public int getBasicWeeklyConsumtion(IWare ware) {
        double d = this.needs.get(ware).get((Object)EPopulationClass.MEDIUM);
        return (int)Math.floor(d);
    }
}

