/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanCity;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanMap;
import ch.sahits.game.openpatrician.model.city.guild.ITradeAgreement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class MediterreanSeaMap
implements IMediterreanMap {
    private final int DETECTION_RADIUS = 10;
    @MultimapType(key=IPlayer.class, value=Point2D.class)
    private Multimap<IPlayer, Point2D> exploredSpots = ArrayListMultimap.create();
    @MapType(key=Point2D.class, value=String.class)
    private Map<Point2D, IMediterreanCity> cities = new HashMap<Point2D, IMediterreanCity>();
    @ListType(value=Point2D.class)
    private List<Point2D> discoveredTradingSpots = new ArrayList<Point2D>();
    @MultimapType(key=IPlayer.class, value=ITradeAgreement.class)
    private Multimap<IPlayer, ITradeAgreement> tradeAgreements = ArrayListMultimap.create();
    @Autowired
    private DateService dateService;

    @Override
    public boolean exploreSpot(IPlayer player, Point2D coordinates) {
        this.exploredSpots.put((Object)player, (Object)coordinates);
        for (Point2D point : this.cities.keySet()) {
            if (!(point.distance(coordinates) <= 10.0)) continue;
            if (this.discoveredTradingSpots.contains(point)) break;
            this.discoveredTradingSpots.add(point);
            return true;
        }
        return false;
    }

    @Override
    public Map<Point2D, IMediterreanCity> getDiscoveredTradingSpots() {
        HashMap<Point2D, IMediterreanCity> discovered = new HashMap<Point2D, IMediterreanCity>();
        for (Point2D point : this.discoveredTradingSpots) {
            discovered.put(point, this.cities.get(point));
        }
        return discovered;
    }

    @Override
    public List<Point2D> getExploredLocations(IPlayer player) {
        return new ArrayList<Point2D>(this.exploredSpots.get((Object)player));
    }

    @VisibleForTesting
    void addCity(Point2D location, IMediterreanCity city) {
        this.cities.put(location, city);
    }

    @Override
    public void addTradeAgreement(IPlayer player, ITradeAgreement agreement) {
        this.cleanupTradeAgreements();
        this.tradeAgreements.put((Object)player, (Object)agreement);
    }

    @Override
    public List<ITradeAgreement> getTradeAgreements(IPlayer player) {
        this.cleanupTradeAgreements();
        return new ArrayList<ITradeAgreement>(this.tradeAgreements.get((Object)player));
    }

    private void cleanupTradeAgreements() {
        for (IPlayer player : this.tradeAgreements.keys()) {
            for (ITradeAgreement agreement : this.tradeAgreements.get((Object)player)) {
                DateTime validity = agreement.getValidTill();
                if (!this.dateService.isPast(validity)) continue;
                this.tradeAgreements.remove((Object)player, (Object)agreement);
            }
        }
    }
}

