/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.personal.IChild;
import org.joda.time.DateTime;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class Child
implements IChild {
    private final String name;
    private final DateTime birthDate;

    Child(String name, DateTime birthDate) {
        this.name = name;
        this.birthDate = birthDate;
    }

    public static ChildBuilder builder() {
        return new ChildBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DateTime getBirthDate() {
        return this.birthDate;
    }

    public static class ChildBuilder {
        private String name;
        private DateTime birthDate;

        ChildBuilder() {
        }

        public ChildBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChildBuilder birthDate(DateTime birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Child build() {
            return new Child(this.name, this.birthDate);
        }

        public String toString() {
            return "Child.ChildBuilder(name=" + this.name + ", birthDate=" + this.birthDate + ")";
        }
    }
}

