/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;
import ch.sahits.game.openpatrician.model.product.IPriceCalculation;

@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
final class LinearPriceCalculation
implements IPriceCalculation {
    LinearPriceCalculation() {
    }

    @Override
    public double computePrice(int min, int max, int available, int saturation, int productionRate, IPopulationStructure pop, ECityState state) {
        if (available == 0) {
            return max;
        }
        if (available >= saturation) {
            return min;
        }
        double slope = (double)(-(max - min)) / (1.0 * (double)saturation);
        return (double)available * slope + (double)max;
    }
}

