/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.sea.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Blockade
implements IBlockade {
    private final DateTime assemblyDate;
    private final DateTime endBlockade;
    @MapType(key=IPlayer.class, value=Integer.class)
    private Map<IPlayer, Integer> requestedShips = new HashMap<IPlayer, Integer>();
    @MultimapType(key=IPlayer.class, value=IShip.class)
    private Multimap<IPlayer, IShip> ships = ArrayListMultimap.create();
    @ListType(value=IShip.class)
    private List<IShip> shipsToAuction = new ArrayList<IShip>();
    private IConvoy convoy;

    public Blockade(DateTime assemblyDate, DateTime endBlockade) {
        this.assemblyDate = assemblyDate;
        this.endBlockade = endBlockade;
    }

    @Override
    public IConvoy getBlockadeConvoy() {
        return this.convoy;
    }

    @Override
    public List<IShip> getShips(IPlayer player) {
        return new ArrayList<IShip>(this.ships.get((Object)player));
    }

    @Override
    public List<IShip> getShips() {
        return new ArrayList<IShip>(this.ships.values());
    }

    public void requestShip(IPlayer player, int number) {
        this.requestedShips.put(player, number);
    }

    @Override
    public int getNumberOfRequestedShips(IPlayer player) {
        return this.requestedShips.get(player);
    }

    @Override
    public List<IPlayer> getPlayersWithRequestedShips() {
        return new ArrayList<IPlayer>(this.requestedShips.keySet());
    }

    @Override
    public void addShips(IPlayer player, List<IShip> shipList) {
        this.ships.putAll((Object)player, shipList);
    }

    @Override
    public DateTime getAssemblyDate() {
        return this.assemblyDate;
    }

    @Override
    public DateTime getEndBlockade() {
        return this.endBlockade;
    }

    @Override
    public List<IShip> getShipsToAuction() {
        return this.shipsToAuction;
    }

    @Override
    public void setConvoy(IConvoy convoy) {
        this.convoy = convoy;
    }
}

