/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MultimapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.javafx.bindings.LateIntegerBinding;
import ch.sahits.game.openpatrician.model.AmountableProvider;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Convoy
implements IConvoy {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private AmountableProvider amountableProvider;
    private final IShip orlegShip;
    private final boolean publicConvoy;
    @MultimapType(key=IPlayer.class, value=IShip.class)
    private Multimap<IPlayer, IShip> ships = ArrayListMultimap.create();
    @XStreamOmitField
    private LateIntegerBinding loadBinding = null;

    public Convoy(IShip orlegShip, boolean publicConvoy) {
        this.orlegShip = orlegShip;
        this.publicConvoy = publicConvoy;
        this.ships.put((Object)((IPlayer)orlegShip.getOwner()), (Object)orlegShip);
    }

    @Override
    public boolean hasWeapons() {
        return false;
    }

    @Override
    public IShip getOrlegShip() {
        return this.orlegShip;
    }

    @Override
    public List<IShip> getShips() {
        ArrayList<IShip> allShips = new ArrayList<IShip>(this.ships.values());
        return allShips;
    }

    private LateIntegerBinding loadbinding() {
        if (this.loadBinding == null) {
            this.loadBinding = this.createLoadBinding();
        }
        return this.loadBinding;
    }

    @Override
    public void addShip(IShip ship) {
        this.ships.put((Object)((IPlayer)ship.getOwner()), (Object)ship);
        this.loadbinding().bind((Observable)ship.getLoadBinding());
        this.loadbinding().invalidate();
    }

    @Override
    public void removeShip(IShip ship) {
        this.ships.remove((Object)ship.getOwner(), (Object)ship);
        this.loadbinding().unbind((Observable)ship.getLoadBinding());
        this.loadbinding().invalidate();
    }

    private LateIntegerBinding createLoadBinding() {
        return new LateIntegerBinding(){
            {
                for (IShip ship : Convoy.this.ships.values()) {
                    super.bind((Observable)ship.getLoadBinding());
                }
            }

            protected int computeValue() {
                return Convoy.this.ships.values().stream().mapToInt(ship -> ship.getLoadBinding().get()).sum();
            }
        };
    }

    @Override
    public int getSize() {
        return this.ships.values().stream().mapToInt(ship -> ship.getSize()).sum();
    }

    @Override
    public int getCapacity() {
        return this.ships.values().stream().mapToInt(ship -> ship.getCapacity()).sum();
    }

    @Override
    public String getName() {
        return this.orlegShip.getName();
    }

    @Override
    public Set<IWare> getLoadedWares() {
        HashSet<IWare> loadedWares = new HashSet<IWare>();
        for (IShip ship : this.ships.values()) {
            loadedWares.addAll(ship.getLoadedWares());
        }
        return loadedWares;
    }

    @Override
    public int load(IWare ware, int amount, int avgPrice) {
        IShip ship;
        int loadedAmount = 0;
        int remainingAmount = amount;
        Iterator iterator = this.ships.values().iterator();
        while (iterator.hasNext() && ((ship = (IShip)iterator.next()).getCapacity() <= 0 || (remainingAmount = amount - (loadedAmount += ship.load(ware, remainingAmount, avgPrice))) > 0)) {
        }
        return loadedAmount;
    }

    @Override
    public int unload(IWare ware, int amount) {
        IShip ship;
        int unloadedAmount = 0;
        int remainingAmount = amount;
        Iterator iterator = this.ships.values().iterator();
        while (iterator.hasNext() && (remainingAmount = amount - (unloadedAmount += (ship = (IShip)iterator.next()).unload(ware, remainingAmount))) > 0) {
        }
        return unloadedAmount;
    }

    @Override
    public int getDamage() {
        return this.ships.values().stream().mapToInt(ship -> ship.getDamage()).max().getAsInt();
    }

    @Override
    public void damage(int damage) {
        for (IShip ship : this.ships.values()) {
            double rndFactor = Math.max(this.rnd.nextGaussian() + 1.0, 0.0);
            double typeFactor = 1.0;
            if (ship instanceof IHolk) {
                typeFactor = 0.75;
            }
            if (ship instanceof ICog) {
                typeFactor = 1.0;
            }
            if (ship instanceof ICrayer) {
                typeFactor = 1.3;
            }
            if (ship instanceof ISnaikka) {
                typeFactor = 1.7;
            }
            int actualDamage = (int)Math.round((double)damage * rndFactor * typeFactor);
            ship.damage(actualDamage);
        }
    }

    @Override
    public IntegerBinding getLoadBinding() {
        return this.loadbinding();
    }

    @Override
    public AmountablePrice<IWare> getWare(IWare ware) {
        AmountablePrice<IWare> loadedWare = this.amountableProvider.createWareAmountable();
        for (IShip ship : this.ships.values()) {
            AmountablePrice<IWare> amountable = ship.getWare(ware);
            loadedWare.add(amountable.getAmount(), amountable.getAVGPrice());
        }
        return loadedWare;
    }

    @Override
    public int getNumberOfSailors() {
        return this.ships.values().stream().mapToInt(ship -> ship.getNumberOfSailors()).sum();
    }

    @Override
    public Optional<ICaptain> getCaptian() {
        return this.orlegShip.getCaptian();
    }

    @Override
    public int getWeaponAmount(IWeapon weaponType) {
        return this.ships.values().stream().mapToInt(ship -> ship.getWeaponAmount(weaponType)).sum();
    }

    @Override
    public Point2D getLocation() {
        return this.orlegShip.getLocation();
    }

    @Override
    public void setLocation(Point2D location) {
        for (IShip ship : this.ships.values()) {
            ship.setLocation(location);
        }
    }

    @Override
    public IShipOwner getOwner() {
        return this.orlegShip.getOwner();
    }

    @Override
    public List<IShip> getShips(IPlayer player) {
        return new ArrayList<IShip>(this.ships.get((Object)player));
    }

    @Override
    public List<IPlayer> getPlayers() {
        return new ArrayList<IPlayer>(this.ships.keySet());
    }

    @Override
    public Map<IPlayer, Integer> getCapacityPerOwner() {
        HashMap<IPlayer, Integer> map = new HashMap<IPlayer, Integer>();
        for (IPlayer player : this.ships.keys()) {
            int capacity = this.getShips(player).stream().mapToInt(ship -> ship.getCapacity()).sum();
            map.put(player, capacity);
        }
        return map;
    }

    @Override
    public int getLoadableSpace() {
        return this.ships.values().stream().mapToInt(ship -> ship.getLoadableSpace()).sum();
    }

    @Override
    public double getTopSpeed() {
        return this.ships.values().stream().mapToDouble(ship -> ship.getTopSpeed()).max().getAsDouble();
    }

    @Override
    public double getCurrentSpeed() {
        return this.ships.values().stream().mapToDouble(ship -> ship.getCurrentSpeed()).min().getAsDouble();
    }

    @Override
    public String getUuid() {
        return this.getOrlegShip().getUuid();
    }

    @Override
    public boolean getPirateFlag() {
        return false;
    }

    @Override
    public void togglePirateFlag() {
    }

    @Override
    public boolean isPublicConvoy() {
        return this.publicConvoy;
    }
}

