package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.city.ProductionStorage;
import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * This interface represents a workshop, which employs workers
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 22, 2012
 *
 */
public interface IWorkShop extends IBuilding {
	/**
	 * Retrieve the number of workers in the shop
	 * @return
	 */
	int getWorkers();
	/**
	 * Retrieve the number of workers maximal employable by this shop
	 * @return
	 */
	int getMaxWorkers();
	/**
	 * Retrieve the salary a worker earns within a week
	 * @return
	 */
	int getSalaryPerWorker();

	/**
	 * Retrieve the ware this workshop produces.
	 * @return
	 */
	IWare getProducableWare();
//
//	/**
//	 * Put some amount of ware into the the workshop store
//	 * @param ware to be stored
//	 * @param amount to be stored
//	 */
//	void store(IWare ware, int amount);
//
//	/**
//	 * Consume wares in small amounnts.
//	 * @param ware to be consumed.
//	 * @param amount to be consumed
//	 */
//	void consumeStoredWares(IWare ware, double amount);
//
//	/**
//	 * Retrieve the total amount of produced wares and remove it from
//	 * the workshops internal store.
//	 * @return Amountable price of the ware considering the amount and the price.
//	 */
//	AmountablePrice<IWare> retrieveProducedWare();

	/**
	 * Retrieve the storage of the workshop.
	 * @return
	 */
	ProductionStorage getStorage();

	/**
	 * Indicating if the produced ware is produced efficiently in the city.
	 * @return
	 */
	boolean isProducingEfficienty();
}
