package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;

import java.util.HashMap;
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AutomatedTrading implements IAutomatedTrading {
	@MapType(key = IWare.class, value = TradableWare.class)
	private HashMap<IWare, TradableWare> wares = new HashMap<IWare, TradableWare>();
	
	public AutomatedTrading() {
		for (EWare ware : EWare.values()) {
			wares.put(ware, new TradableWare());
		}
	}

	@Override
	public int getAmount(IWare ware) {
		return wares.get(ware).getAmount();
	}
	@Override
	public IntegerProperty amountProperty(IWare ware) {
		return wares.get(ware).amountProperty();
	}

	@Override
	public int getPrice(IWare ware) {
		return wares.get(ware).getPrice();
	}
	@Override
	public IntegerProperty priceProperty(IWare ware) {
		return wares.get(ware).priceProperty();
	}

	@Override
	public ObjectProperty<ETradeType> tradingTypeProperty(IWare ware) {
		return  wares.get(ware).tradeTypeProperty();
	}

	@Override
	public boolean isMovableToShip(IWare ware) {
		return  wares.get(ware).isMovable2Ship();
	}
	@Override
	public BooleanProperty movableToShipProperty(IWare ware) {
		return wares.get(ware).moveable2ShipProperty();
	}

	@Override
	public void updateAmount(IWare ware, int difference) {
		TradableWare tw = wares.get(ware);
		tw.setAmount(tw.getAmount()+difference);
	}

	@Override
	public void updatePrice(IWare ware, int difference) {
		TradableWare tw = wares.get(ware);
		tw.setPrice(tw.getPrice()+difference);
	}

	@Override
	public void setTradingType(IWare ware, ETradeType tt) {
		wares.get(ware).setTradingType(tt);
	}

	@Override
	public void setMovableToShip(IWare ware, boolean isMovable) {
		wares.get(ware).setMovable2Ship(isMovable);
	}
	
}
