package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;
import lombok.Getter;

@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class Steward implements ISteward {
	@Getter
	private int expertiseLevel;
    @Getter
	private int salary;

	private int totalProfit;
	

	public Steward() {
		this.expertiseLevel = 0;
		this.salary = 5;
		this.totalProfit = 0;

	}

	@Override
	public int getTotalProfit() {
		return totalProfit;
	}

	@Override
	public void updateProfit(int profit) {
		totalProfit += profit;
	}

	@Override
	public void upgradeToNextLevel() {
		Preconditions.checkArgument(expertiseLevel < 5, "Cannot exceed experiance level 5");
		expertiseLevel++;
		salary = (int) (1.8 * salary);
	}
}
