package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import ch.sahits.game.openpatrician.model.building.ETradeType;
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
class TradableWare {

	private IntegerProperty amount;
	private IntegerProperty price;
	private BooleanProperty movable2Ship;
	@ObjectPropertyType(ETradeType.class)
	private ObjectProperty<ETradeType> tt;
	
	public TradableWare() {
		amount = new SimpleIntegerProperty(this, "amount", 0);
		price = new SimpleIntegerProperty(this, "price", 0);
		tt= new SimpleObjectProperty<ETradeType>(this, "tradeType", ETradeType.NONE);
		movable2Ship = new SimpleBooleanProperty(this, "movable2Ship", false);
	}
	
	public int getAmount() {
		return amount.get();
	}
	/**
	 * Do not set negative amounts
	 * @param amount
	 */
	public void setAmount(int amount) {
		this.amount.set(Math.max(0, amount));
	}
	public IntegerProperty amountProperty() {
		return amount;
	}
	public int getPrice() {
		return price.get();
	}
	/**
	 * Do not set negative prices
	 * @param price
	 */
	public void setPrice(int price) {
		this.price.set(Math.max(0, price));
	}
	public IntegerProperty priceProperty() {
		return price;
	}
	public boolean isMovable2Ship() {
		return movable2Ship.get();
	}
	public void setMovable2Ship(boolean movable2Ship) {
		this.movable2Ship.set(movable2Ship);
	}
	public BooleanProperty moveable2ShipProperty() {
		return movable2Ship;
	}
	public ETradeType getTradingType() {
		return tt.get();
	}
	public void setTradingType(ETradeType tt) {
		if (tt!=ETradeType.NONE && tt!=ETradeType.CITY_OFFICE && tt!=ETradeType.OFFICE_CITY){
			throw new IllegalArgumentException("Illegal trading type");
		}
		this.tt.set(tt);
	}
	public ObjectProperty<ETradeType> tradeTypeProperty() {
		return tt;
	}
}
