package ch.sahits.game.openpatrician.model.city;

import java.util.Optional;
import lombok.Getter;

/**
 * Defining the extension levels for the church.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 21, 2015
 */
public enum EChurchExtension {
    NONE(0),
    EXTENDED_ONCE(20000),
    EXTENDED_TWICE(100000);
    @Getter
    private final int requiredCash;

    EChurchExtension(int requiredCash) {
        this.requiredCash = requiredCash;
    }

    /**
     * Retrieve the next extension level if one is available.
     * @return
     */
    public Optional<EChurchExtension> getNextExtensionLevel() {
        if (this == NONE) {
            return Optional.of(EXTENDED_ONCE);
        }
        if (this == EXTENDED_ONCE) {
            return Optional.of(EXTENDED_TWICE);
        }
        return Optional.empty();
    }
}
