package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.map.PirateMapSegmentImage;
import ch.sahits.game.openpatrician.model.city.cityhall.ICapturePirateNest;
import javafx.geometry.Point2D;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
@Prototype
public class CapturePirateNest extends AldermanTask implements ICapturePirateNest {
    @Getter
    private final Point2D location;
    @Getter
    private final PirateMapSegmentImage pirateNestMap;

    public CapturePirateNest(int duration, Point2D location, PirateMapSegmentImage pirateNestMap) {
        super(duration);
        this.location = location;
        this.pirateNestMap = pirateNestMap;
    }
}
