package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.experimental.Builder;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Builder
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class CityHallNotice implements ICityHallNotice {
    @Getter
    private final IContractBroker contact;
    @Getter
    private final IWare requiredWare;
    @Getter
    private final ICity destination;
    @Getter
    private final AmountablePrice<IWare> wareAndAmount;
    @Getter
    private final LocalDateTime dueDate;


}