package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.impl.ECityLabelAlignment;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.cityhall.IFoundNewSettlement;
import javafx.geometry.Point2D;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class FoundNewSettlement extends AldermanTask implements IFoundNewSettlement {
    @Getter
    private final Point2D location;
    @Getter
    private final String name;
    @Getter
    private final boolean river;
    @Getter
    private final Point2D cityLabelOffset;
    @Getter
    private final ECityLabelAlignment cityLabelAlignment;

    public FoundNewSettlement(int duration, Point2D location, String name, boolean river, Point2D cityLabelOffset, ECityLabelAlignment cityLabelAlignment) {
        super(duration);
        this.location = location;
        this.name = name;
        this.river = river;
        this.cityLabelAlignment = cityLabelAlignment;
        this.cityLabelOffset = cityLabelOffset;
    }
}
