package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanCity;
import ch.sahits.game.openpatrician.model.product.IWare;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 04, 2016
 */
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
@Getter
public class MediterreanCity implements IMediterreanCity{
    private final String name;
    @ListType(IWare.class)
    private final List<IWare> consumingWares = new ArrayList<>();
    @ListType(IWare.class)
    private final List<IWare> producingWares = new ArrayList<>();

    public MediterreanCity(String name, IWare consumingWare1, IWare consumingWare2, IWare producingWare1, IWare producingWare2) {
        this.name = name;
        consumingWares.add(consumingWare1);
        consumingWares.add(consumingWare2);
        producingWares.add(producingWare1);
        producingWares.add(producingWare2);
    }
}
