package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import com.google.common.base.Preconditions;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class LoanerState implements ILoaner{
    @Value("${loaner.max.age.request}")
    private int maxRequestsPerWeek;

    @Getter
    private final ICity city;
    @Getter
    @ListType(IDebt.class)
    private List<IDebt> debts = new ArrayList<>();
    @Getter
    @ListType(ILoanRequest.class)
    private List<ILoanRequest> requests = new ArrayList<>();
    @Getter
    @ListType(ILoanProposal.class)
    private List<ILoanProposal> loanProposals = new ArrayList<>();
    @Autowired
    private Date date;
    public LoanerState(ICity city) {
        this.city = city;
    }

    public void add(LoanProposal proposal) {
        loanProposals.add(proposal);
    }

    public void add(LoanRequest request) {
        requests.add(request);
    }

    public void clearOldRequests() {
        LocalDateTime now = date.getCurrentDate();
        LocalDateTime before4Weeks = now.minusWeeks(maxRequestsPerWeek);
        for (Iterator<ILoanRequest> iterator = requests.iterator(); iterator.hasNext(); ) {
            ILoanRequest request = iterator.next();
            if (request.issued().isBefore(before4Weeks)) {
                iterator.remove();
            }
        }
    }


    @Override
    public void addDebt(IDebt debt) {
        LocalDateTime now = date.getCurrentDate();
        Preconditions.checkArgument(debt.getDueDate().isAfter(now));
        debts.add(debt);
    }
}
