package ch.sahits.game.openpatrician.model.event;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * Timed task with a specified execution time. The run method is
 * supposed to be executed at the execution time.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 28, 2013
 *
 */
@Getter
@Setter
public abstract class TimedTask implements Runnable {

    private LocalDateTime executionTime;

    protected TimedTask() {
    }

}
