package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;


interface IBasePatrol extends ISideRoomPerson {

	/**
	 * Get the name of the client.
	 * @return
	 */
	String getName();

	/**
	 * Set the name of the client.
	 * @param name of the client
	 */
	void setName(String name);
	/**
	 * Retrieve the destinations
	 * @return
	 */
	ICity[] getDestinations();

	/**
	 * Set the destination city of the patrol.
	 * @param cities
     */
	void setDestinations(ICity[] cities);
	/**
	 * Retrieve the premium for successful finishing the patrol.
	 * @return
	 */
	int getPremium();

	/**
	 * Set the premium for task completion.
	 * @param premium
     */
	void setPremium(int premium);

	/**
	 * Set the current index in the destination list.
	 * @param index
     */
	void setCurrentDestIndex(int index);

	/**
	 * Retrieve the current index in the destination list.
	 * @return
     */
	int getCurrentDestIndex();

}